import matplotlib.pyplot as plt
import matplotlib.image as mpimg
import numpy as np
import cv2
import sys

def draw_circle(circles, img):
    if circles is not None:
        print(len(circles))
        circles = np.uint16(np.around(circles))
        for i in circles[0, :]:
            center = (i[0], i[1])
            # circle center
            cv2.circle(img, center, 1, (0, 100, 100), 3)
            # circle outline
            radius = i[2]
            cv2.circle(img, center, radius, (255, 0, 255), 3)


def draw_lines(img, houghLines, color=[0, 255, 0], thickness=1):
    print(len(houghLines))
    for line in houghLines:
        for rho,theta in line:
            a = np.cos(theta)
            b = np.sin(theta)
            x0 = a*rho
            y0 = b*rho
            x1 = int(x0 + 2000*(-b))
            y1 = int(y0 + 2000*(a))
            x2 = int(x0 - 2000*(-b))
            y2 = int(y0 - 2000*(a))

            cv2.line(img,(x1,y1),(x2,y2),color,thickness)



def weighted_img(img, initial_img, α=0.8, β=1., λ=0.):
    return cv2.addWeighted(initial_img, α, img, β, λ)

def run_segment(img):
    original = img
    image = img
    gray_image = cv2.cvtColor(image, cv2.COLOR_RGB2GRAY)
    blurred_image = cv2.GaussianBlur(img, (15, 15), 0)
    #blurred_image_Copy = np.uint8(blurred_image)
    src = cv2.Canny(blurred_image, 143, 43) #(cv2.Canny(bilde , lower threshold, upper threshold))
    if src is None:
        print ('Error opening image!')
        print ('Usage: hough_lines.py [image_name -- default ' + default_file + '] \n')
        return -1



    cdst = cv2.cvtColor(src, cv2.COLOR_GRAY2BGR)
    cdstP = np.copy(cdst)

    rho_resolution = 1
    theta_resolution = np.pi/180
    threshold = 138

    linesP = cv2.HoughLinesP(src, rho_resolution, theta_resolution, threshold, None, 2, 3)



    if linesP is not None:
        for i in range(0, len(linesP)):
            l = linesP[i][0]
            cv2.line(cdstP, (l[0], l[1]), (l[2], l[3]), (0,0,255), 3, cv2.LINE_AA)

    cv2.imshow("Detected Lines (in red) - Probabilistic Line Transform", cdstP)

    cv2.waitKey()
    return 0

def get_blur(img):
    image = img
    gray_image = cv2.cvtColor(image, cv2.COLOR_RGB2GRAY)
    blurred_image_gray = cv2.GaussianBlur(gray_image, (9, 9), 0)
    blurred_image_original = cv2.GaussianBlur(img, (9, 9), 0)


    plt.figure(figsize = (30,30))
    plt.subplot(131)
    plt.imshow(img)
    plt.subplot(132)
    plt.imshow(blurred_image_gray, cmap='gray')
    plt.subplot(133)
    plt.imshow(blurred_image_original)

    plt.show()

def run_line(img):
    image = img
    gray_image = cv2.cvtColor(image, cv2.COLOR_RGB2GRAY)
    blurred_image = cv2.GaussianBlur(gray_image, (9, 9), 0)
    #blurred_image_Copy = np.uint8(blurred_image)
    edges_image = cv2.Canny(blurred_image, 10, 100) #(cv2.Canny(bilde , lower threshold, upper threshold))


    rho_resolution = 1
    theta_resolution = np.pi/180
    threshold = 175

    hough_lines = cv2.HoughLines(edges_image, rho_resolution , theta_resolution , threshold)

    hough_lines_image = np.zeros_like(image)
    #draw_lines(hough_lines_image, hough_lines)
    draw_lines(hough_lines_image, hough_lines)
    original_image_with_hough_lines = weighted_img(hough_lines_image,image)

    plt.figure(figsize = (10,10))
    #plt.subplot(131)
    #plt.imshow(gray_image)
    #plt.subplot(132)
    #plt.imshow(edges_image, cmap='gray')
    plt.subplot(111)
    plt.imshow(original_image_with_hough_lines, cmap='gray')

    plt.show()
