import matplotlib.pyplot as plt
import matplotlib.image as mpimg
import numpy as np
import cv2

def draw_lines(img, houghLines, color=[0, 255, 0], thickness=2):
    print(len(houghLines))
    for line in houghLines:
        for rho,theta in line:
            a = np.cos(theta)
            b = np.sin(theta)
            x0 = a*rho
            y0 = b*rho
            x1 = int(x0 + 2000*(-b))
            y1 = int(y0 + 2000*(a))
            x2 = int(x0 - 2000*(-b))
            y2 = int(y0 - 2000*(a))

            cv2.line(img,(x1,y1),(x2,y2),color,thickness)
            if color == [0, 255, 0]:
                color = [255, 0, 0]
            elif color == [255, 0, 0]:
                color = [0, 0, 255]
            elif color == [0,0,255]:
                color = [255,255,0]
            elif color == [255,255,0]:
                color = [255,0,255]
            elif color == [255,0,255]:
                color = [0,255,0]





def weighted_img(img, initial_img, α=0.8, β=1., λ=0.):
    return cv2.addWeighted(initial_img, α, img, β, λ)

def blur(img):
    image = img
    """
    gray_image = cv2.cvtColor(img, cv2.COLOR_RGB2GRAY)
    blurred_image = cv2.GaussianBlur(gray_image, (11, 11), 0)
    #blurred_image_Copy = np.uint8(blurred_image)
    edges_image = cv2.Canny(gray_image, 50, 120) #(cv2.Canny(bilde , lower threshold, upper threshold))
    #edges_image = cv2.Sobel(blurred_image_Copy, 10, 100)
    """
    sobelx = cv.Sobel(img,cv.CV_64F,1,0,ksize=5)
    sobely = cv.Sobel(img,cv.CV_64F,0,1,ksize=5)





    plt.figure(figsize = (20,20))
    plt.subplot(121)
    plt.imshow(sobelx, cmap='gray')
    plt.subplot(122)
    plt.imshow(sobely, cmap='gray')
    plt.show()

def funcCan(thresh1=0):
    lineBol = cv2.getTrackbarPos('lineBol', 'canny')

    gray_image = cv2.cvtColor(img, cv2.COLOR_RGB2GRAY)
    blur = cv2.getTrackbarPos('blur', 'canny')
    thresh1 = cv2.getTrackbarPos('thresh1', 'canny')
    thresh2 = cv2.getTrackbarPos('thresh2', 'canny')
    thresholdL = cv2.getTrackbarPos('thresholdL', 'canny')
    blur_img =cv2.GaussianBlur(img,(blur,blur),0)
    edge = cv2.Canny(blur_img, thresh1, thresh2)
    if lineBol == 1:
        run(mpimg.imread("C:\\Users\\Gard\\OneDrive\\Skrivebord\\cv_project\\img\\540px-Skrik_1893.jpg"), blur, thresh1, thresh2, thresholdL)
    cv2.imshow('canny', edge)

def run(img, blur, lower, upper, thresholdLines):
    image = img
    gray_image = cv2.cvtColor(img, cv2.COLOR_RGB2GRAY)

    blurred_image = cv2.GaussianBlur(img, (blur, blur), 0)

    edges_image = cv2.Canny(blurred_image, lower, upper) #(cv2.Canny(bilde , lower threshold, upper threshold))
    #edges_image = cv2.Sobel(blurred_image_Copy, 10, 100)

    rho_resolution = 1
    theta_resolution = np.pi/180
    threshold = thresholdLines

    hough_lines = cv2.HoughLines(edges_image, rho_resolution , theta_resolution , threshold)

    hough_lines_image = np.zeros_like(image)
    draw_lines(hough_lines_image, hough_lines)

    original_image_with_hough_lines = weighted_img(hough_lines_image,image)

    plt.figure(figsize = (20,10))
    plt.subplot(121)
    plt.imshow(edges_image,  cmap='gray')
    plt.axis('off')
    plt.subplot(122)
    plt.imshow(original_image_with_hough_lines,  cmap='gray')
    #get current axes
    plt.axis('off')
    plt.show()
"""
    plt.figure(figsize = (30,20))
    plt.subplot(131)
    plt.imshow(blurred_image,  cmap='gray')
    plt.subplot(132)
    plt.imshow(edges_image, cmap='gray')
    plt.subplot(133)
    plt.imshow(original_image_with_hough_lines, cmap='gray')
"""


if __name__== '__main__':
    #blur(mpimg.imread("C:\\Users\\Gard\\OneDrive\\Skrivebord\\cv_project\\img\\580px-The_Scream_by_Edvard_Munch__1893_-_Nasjonalgalleriet.jpg")
    original=cv2.imread("<img_path>", 1)
    img=original.copy()
    cv2.namedWindow('canny')
    thresh1=100
    thresh2=1
    blur = 5
    lineBol = 0
    thresholdL = 0
    cv2.createTrackbar('blur','canny',blur,30,funcCan)
    cv2.createTrackbar('thresh1','canny',thresh1,255,funcCan)
    cv2.createTrackbar('thresh2','canny',thresh2,255,funcCan)
    cv2.createTrackbar('lineBol','canny',lineBol,1,funcCan)
    cv2.createTrackbar('thresholdL','canny',thresholdL,255,funcCan)
    funcCan(0)
    cv2.imshow('Frame',original)
    cv2.waitKey(0)

cv2.destroyAllWindows()



#run(mpimg.imread("C:\\Users\\Gard\\OneDrive\\Skrivebord\\cv_project\\img\\541px-The_Scream_Pastel.jpg"))
